/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jade.provider;

import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import mcp.mobius.waila.impl.ui.ProgressArrowElement;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import reliquary.blocks.ApothecaryMortarBlock;
import reliquary.blocks.tile.ApothecaryMortarBlockEntity;
import reliquary.compat.jade.provider.CachedBodyDataProvider;
import reliquary.init.ModItems;
import reliquary.items.PotionEssenceItem;
import reliquary.util.potions.PotionIngredient;
import reliquary.util.potions.XRPotionHelper;
import snownee.jade.VanillaPlugin;

public class DataProviderMortar
extends CachedBodyDataProvider
implements IServerDataProvider<BlockEntity> {
    private List<MobEffectInstance> effects;

    @Override
    public List<List<IElement>> getWailaBodyToCache(IElementHelper helper, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity;
        ArrayList<List<IElement>> lines = new ArrayList<List<IElement>>();
        if (!(accessor.getBlock() instanceof ApothecaryMortarBlock) || !((blockEntity = accessor.getBlockEntity()) instanceof ApothecaryMortarBlockEntity)) {
            return lines;
        }
        ApothecaryMortarBlockEntity mortar = (ApothecaryMortarBlockEntity)blockEntity;
        NonNullList<ItemStack> ingredientStacks = mortar.getItemStacks();
        ArrayList<IElement> ingredients = new ArrayList<IElement>();
        ArrayList<PotionIngredient> potionIngredients = new ArrayList<PotionIngredient>();
        for (ItemStack ingredientStack : ingredientStacks) {
            if (ingredientStack.m_41619_()) continue;
            ingredients.add(helper.item(ingredientStack));
            XRPotionHelper.getIngredient(ingredientStack).ifPresent(potionIngredients::add);
        }
        lines.add(ingredients);
        this.effects = XRPotionHelper.combineIngredients(potionIngredients);
        ArrayList<Component> effectTooltips = new ArrayList<Component>();
        if (!this.effects.isEmpty()) {
            int pestleUsedCounter = accessor.getServerData().m_128451_("pestleUsedCounter");
            lines.add(this.createPestleProgress(helper, pestleUsedCounter));
            XRPotionHelper.addPotionTooltip(this.effects, effectTooltips);
            lines.addAll(effectTooltips.stream().map(text -> List.of(helper.text(text))).toList());
        }
        return lines;
    }

    public List<IElement> createPestleProgress(IElementHelper helper, int pestleUsedCounter) {
        ItemStack stack = ((PotionEssenceItem)ModItems.POTION_ESSENCE.get()).m_7968_();
        XRPotionHelper.addPotionEffectsToStack(stack, this.effects);
        return List.of(new ProgressArrowElement((float)pestleUsedCounter / 5.0f), helper.item(stack));
    }

    @Override
    public List<List<IElement>> updateCache(IElementHelper helper, BlockAccessor accessor, List<List<IElement>> cached) {
        if (cached.size() > 1) {
            int pestleUsedCounter = accessor.getServerData().m_128451_("pestleUsedCounter");
            cached.set(1, this.createPestleProgress(helper, pestleUsedCounter));
        }
        return cached;
    }

    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity t, boolean showDetails) {
        ApothecaryMortarBlockEntity be = (ApothecaryMortarBlockEntity)t;
        data.m_128405_("pestleUsedCounter", be.getPestleUsedCounter());
    }

    @Override
    public void beforeAppending(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        tooltip.remove(VanillaPlugin.INVENTORY);
        super.beforeAppending(tooltip, accessor, pluginConfig);
    }
}

